# 🚀 ThangLQ Stack - Remote Modular LEMP Stack

**ThangLQ Stack** là một hệ thống script modular tự động cài đặt và quản lý LEMP stack hiện đại. Scripts được tải xuống tự động từ server remote khi cần thiết, đảm bảo bạn luôn có phiên bản mới nhất.

## 🎯 Tính năng chính

### 💪 Core Stack Components
- **Standard Nginx** - Web server từ source với tối ưu cơ bản
- **OpenResty** - Nginx + LuaJIT với ecosystem Lua modules
- **PHP-FPM Multi-Version** - Hỗ trợ đa phiên bản PHP đồng thời
- **MariaDB** - Database server hiệu suất cao
- **Memcached** - In-memory caching từ source  
- **Redis** - Data structure store đa năng

### 🔧 Advanced Features
- **Remote Script Loading** - Scripts tải xuống tự động từ server
- **Intelligent Caching** - Cache scripts local, auto-update
- **Modular Architecture** - Từng component riêng biệt, dễ maintain
- **Commercial Modules** - Performance và Security modules có thể thương mại hóa
- **Multi-PHP Management** - Cài đặt và quản lý nhiều phiên bản PHP
- **Virtual Host Manager** - Tạo, xóa, quản lý vhosts với SSL
- **Extension Manager** - Quản lý PHP extensions từ source
- **Auto Configuration** - Tự động tối ưu dựa trên tài nguyên hệ thống

### 🛡️ Security & Performance
- **SSL/TLS Management** - Quản lý chứng chỉ SSL tự động
- **Security Headers** - Bảo mật web hiện đại
- **Rate Limiting** - Chống DDoS và abuse
- **Performance Optimization** - Auto-tuning (Commercial)
- **Security Hardening** - Advanced security (Commercial)

## 📋 Yêu cầu hệ thống

### Supported OS
- ✅ AlmaLinux 8/9
- ✅ Rocky Linux 8/9  
- ✅ CentOS 7/8 (Stream)
- ✅ RHEL 8/9

### Hardware Requirements
- **RAM tối thiểu**: 2GB (khuyến nghị 4GB+)
- **Disk space**: 10GB trống (khuyến nghị 20GB+)
- **CPU**: 1 core (khuyến nghị 2+ cores)
- **Network**: Kết nối internet ổn định (bắt buộc)

## 🚀 Cài đặt siêu nhanh

### Phương pháp 1: One-command install (Khuyến nghị)
```bash
# Download và chạy trực tiếp
curl -sSL http://scripts.thanglq.dev/install.sh | sudo bash

# Hoặc download rồi chạy
wget http://scripts.thanglq.dev/install.sh
sudo bash install.sh
```

### Phương pháp 2: Quick install toàn bộ stack
```bash
# Download và cài đặt complete stack ngay lập tức
curl -sSL http://scripts.thanglq.dev/install.sh | sudo bash -s install

# Hoặc download rồi chạy quick install
wget http://scripts.thanglq.dev/install.sh
sudo bash install.sh install
```

### Phương pháp 3: Manual download và customize
```bash
# Download standalone installer
wget http://scripts.thanglq.dev/install.sh
chmod +x install.sh

# Chạy sẽ tự động download config.conf và utils/common.sh
sudo ./install.sh
```

### What happens when you run install.sh?
1. **Auto-download Dependencies**: Script tự động tải `config.conf` và `utils/common.sh`
2. **System Check**: Kiểm tra OS, RAM, disk space, internet connectivity
3. **Component Loading**: Load tất cả utilities và configuration
4. **Interactive Menu**: Hiển thị menu để chọn components cần cài đặt

> **Lưu ý**: End user chỉ cần download `install.sh` duy nhất. Tất cả dependencies sẽ được tải tự động!

### Fallback Mechanism
Nếu remote server không khả dụng, script sẽ tự động fallback về sử dụng file local:
1. **Ưu tiên Remote**: Thử download script từ `$SCRIPTS_BASE_URL`
2. **Fallback Local**: Nếu download thất bại, sử dụng file trong thư mục hiện tại
3. **Error Handling**: Báo lỗi nếu cả remote và local đều không có

```
[WARNING] Remote download failed, using local file: modules/cache/redis.sh
[SUCCESS] Loaded local module: modules/cache/redis.sh
```

## 📁 Kiến trúc Remote Scripts

### Script Server Structure
```
http://scripts.thanglq.dev/
├── install.sh               # 🚀 STANDALONE INSTALLER (main entry point)
├── config.conf              # Configuration file (auto-downloaded)
├── utils/
│   └── common.sh            # Common utilities (auto-downloaded)
├── modules/
│   ├── core/
│   │   └── nginx.sh         # Standard Nginx module
│   ├── web/
│   │   ├── openresty.sh     # OpenResty + Lua module
│   │   └── php-fpm.sh       # Multi-version PHP-FPM module
│   ├── database/
│   │   └── mariadb.sh       # MariaDB module
│   ├── cache/
│   │   ├── memcached.sh     # Memcached module
│   │   └── redis.sh         # Redis module
│   ├── performance/         # 🔒 Commercial module
│   │   └── performance.sh   # Advanced performance tuning
│   └── security/            # 🔒 Commercial module  
│       └── security.sh      # Advanced security hardening
├── scripts/
│   ├── vhost-manager.sh     # Virtual host management
│   └── php-extension-manager.sh # PHP extensions management
└── index.txt                # Available scripts index
```

### Download Flow
```
User downloads install.sh
         ↓
install.sh auto-downloads:
   • config.conf
   • utils/common.sh
         ↓
User selects features
         ↓
Modules downloaded on-demand:
   • modules/web/openresty.sh
   • scripts/vhost-manager.sh
   • etc.
```

### Local Structure After First Run
```
your-directory/
├── install.sh               # Main installer (downloaded by user)
├── config.conf              # Auto-downloaded configuration
└── utils/
    └── common.sh            # Auto-downloaded utilities

/tmp/thanglq-scripts/        # Scripts cache directory
├── modules/                 # Downloaded on-demand
├── scripts/                 # Downloaded on-demand
└── utils/                   # Common utilities cache
```

## 🎛️ Sử dụng

### Quick Install Options
```
=== Installation Options ===
1) Run interactive installer (recommended)
2) Quick install complete LEMP stack  
3) Just download scripts and exit
4) Test remote server and exit
```

### Main Menu Structure
```
=== INSTALLATION MODULES ===
1)  Install Nginx (Standard)
2)  Install OpenResty (Nginx + Lua)  
3)  Install PHP-FPM
4)  Install MariaDB
5)  Install Memcached
6)  Install Redis

=== UPGRADE/MANAGEMENT ===
7)  Upgrade/Downgrade Nginx
8)  Upgrade/Downgrade OpenResty
9)  Upgrade/Downgrade PHP-FPM
10) PHP Extensions Manager

=== VIRTUAL HOSTS ===
11) Create Virtual Host
12) Delete Virtual Host  
13) List Virtual Hosts

=== SYSTEM MANAGEMENT ===
14) System Information
15) Service Status
16) View Logs
17) Update Scripts Cache

=== COMMERCIAL MODULES === (Nếu enabled)
18) Performance Tuning (Pro)
19) Security Hardening (Pro)
```

### Scripts Cache Management

#### Automatic Caching
- Scripts tự động download khi cần
- Cache trong `/tmp/thanglq-scripts/`
- Auto-update mỗi 1 giờ (nếu enabled)

#### Manual Cache Management
```bash
# Update cache từ menu chính (option 17)
./install.sh
> 17) Update Scripts Cache
> 1) Update all cached scripts

# Hoặc command line
./install.sh cache-update
```

## ⚙️ Configuration

### Remote Scripts Configuration
```bash
# Trong config.conf
SCRIPTS_BASE_URL="http://scripts.thanglq.dev"
SCRIPTS_CACHE_DIR="/tmp/thanglq-scripts"
AUTO_UPDATE_SCRIPTS="true"
```

### Đổi Domain Scripts Server
```bash
# Edit config.conf
SCRIPTS_BASE_URL="http://your-domain.com/scripts"

# Hoặc set environment variable
export SCRIPTS_BASE_URL="http://your-domain.com/scripts"
```

### Main Configuration (`config.conf`)
```bash
# Branding & Paths
BRAND_NAME="ThangLQ Stack"
BRAND_URL="https://thanglq.dev"
STACK_DIR="/usr/local/thanglq"
LOG_DIR="/var/log/thanglq"

# Remote Scripts
SCRIPTS_BASE_URL="http://scripts.thanglq.dev"
AUTO_UPDATE_SCRIPTS="true"

# Software Versions
OPENRESTY_VERSION="1.25.3.1"
PHP_DEFAULT_VERSION="8.3.13"
MARIADB_VERSION="10.11"

# Commercial Modules
PERFORMANCE_MODULE_ENABLED="false"
SECURITY_MODULE_ENABLED="false"
```

## 🔍 Giám sát và Log

### Log Files
- **Installation**: `/var/log/thanglq/install.log`
- **Nginx**: `/var/log/thanglq/nginx/`
- **PHP-FPM**: `/var/log/thanglq/php*/`
- **Vhosts**: `/var/www/vhosts/domain.com/logs/`
- **Scripts Cache**: Logged in installation log

### Monitoring Commands
```bash
# System status
systemctl status nginx openresty php-fpm mariadb memcached redis

# Scripts cache status
ls -la /tmp/thanglq-scripts/
du -sh /tmp/thanglq-scripts/

# View real-time logs
tail -f /var/log/thanglq/install.log

# Remote server availability
curl -I http://scripts.thanglq.dev/install.sh
```

## 💡 Tính năng Remote Scripts

### Advantages
- ✅ **Always Updated**: Luôn sử dụng phiên bản mới nhất
- ✅ **Minimal Download**: Chỉ download script khi cần
- ✅ **Intelligent Caching**: Cache local để giảm bandwidth
- ✅ **Modular Loading**: Load từng module riêng biệt
- ✅ **Fallback Support**: Retry mechanism khi download fail
- ✅ **Bandwidth Efficient**: Chỉ download khi thay đổi

### How It Works
1. **First Run**: Download main scripts (install.sh, config.conf, utils/common.sh)
2. **Module Loading**: Scripts download modules khi user chọn feature
3. **Intelligent Caching**: Check timestamp, chỉ download nếu cũ hơn 1 giờ
4. **Retry Mechanism**: 3 lần retry với timeout handling
5. **Error Handling**: Fallback gracefully nếu server unavailable

### Cache Management
```bash
# View cache status
find /tmp/thanglq-scripts/ -name "*.sh" -exec ls -la {} \;

# Force update all cached scripts
rm -rf /tmp/thanglq-scripts/ && ./install.sh

# Check individual script age
stat /tmp/thanglq-scripts/modules/web/openresty.sh
```

## 💰 Commercial Modules

### Performance Module (Pro) 🚀
- **Auto Stack Optimization**: Intelligent resource allocation
- **Advanced Monitoring**: Real-time performance dashboards  
- **Benchmark Tools**: Comprehensive testing suite
- **Custom Tuning**: Application-specific optimizations

### Security Module (Pro) 🛡️
- **Security Auditing**: Comprehensive vulnerability assessment
- **WAF & DDoS Protection**: Advanced threat mitigation
- **Compliance**: PCI DSS, ISO 27001 ready
- **24/7 Monitoring**: Real-time threat detection

### Licensing
```bash
# Enable commercial modules trong config.conf
PERFORMANCE_MODULE_ENABLED="true"
PERFORMANCE_MODULE_LICENSE="your-license-key"

SECURITY_MODULE_ENABLED="true"  
SECURITY_MODULE_LICENSE="your-license-key"
```

**Contact**: sales@thanglq.dev

## 🛠️ Development & Server Setup

### Setting Up Scripts Server

#### Option 1: Simple HTTP Server
```bash
# Setup static file server
mkdir -p /var/www/scripts
cd /var/www/scripts

# Copy all scripts maintaining structure
cp -r thanglq-stack/* .

# Create index file
find . -name "*.sh" > index.txt

# Start simple HTTP server (for development)
python3 -m http.server 8080
```

#### Option 2: Nginx Static Server
```nginx
server {
    listen 80;
    server_name scripts.thanglq.dev;
    root /var/www/scripts;
    
    location / {
        autoindex on;
        add_header Access-Control-Allow-Origin *;
    }
    
    location ~ \.sh$ {
        add_header Content-Type text/plain;
    }
}
```

### Adding New Modules
1. Tạo script trong structure đúng
2. Upload lên scripts server
3. Update index.txt
4. Test với `curl -I http://scripts.thanglq.dev/path/to/new-script.sh`

## 🔧 Troubleshooting

### Common Issues

**1. Cannot access remote scripts server**
```bash
# Check internet connectivity
ping 8.8.8.8

# Test server accessibility  
curl -I http://scripts.thanglq.dev/install.sh

# Check DNS resolution
nslookup scripts.thanglq.dev
```

**2. Scripts cache issues**
```bash
# Clear cache and retry
rm -rf /tmp/thanglq-scripts/
./install.sh

# Check cache permissions
ls -la /tmp/thanglq-scripts/
```

**3. Download failures**
```bash
# Check available disk space
df -h /tmp/

# Manual download test
curl -v http://scripts.thanglq.dev/modules/web/nginx.sh

# Check log for details
tail -f /var/log/thanglq/install.log
```

**4. Module loading errors**
```bash
# Check individual module
curl -f http://scripts.thanglq.dev/modules/web/openresty.sh

# Verify script syntax
bash -n /tmp/thanglq-scripts/modules/web/openresty.sh
```

## 🤝 Contributing

### For Developers
1. Fork repository
2. Create feature branch
3. Follow modular architecture
4. Test with remote server setup
5. Submit pull request

### Module Development Guidelines
- Use common utilities from `utils/common.sh`
- Follow logging standards
- Implement proper error handling
- Support upgrade/downgrade functions
- Include status and configuration commands
- Test with remote loading

## 📞 Support

### Community Support
- **GitHub Issues**: [https://github.com/thanglq/stack/issues](https://github.com/thanglq/stack/issues)
- **Documentation**: [https://docs.thanglq.dev](https://docs.thanglq.dev)

### Commercial Support
- **Email**: support@thanglq.dev
- **Website**: [https://thanglq.dev](https://thanglq.dev)
- **Pro Modules**: sales@thanglq.dev

### Scripts Server Status
- **Base URL**: http://scripts.thanglq.dev
- **Index**: http://scripts.thanglq.dev/index.txt
- **Status**: [https://status.thanglq.dev](https://status.thanglq.dev)

## 📄 License

ThangLQ Stack được phát hành dưới [MIT License](LICENSE).

**Commercial modules** require separate licensing.

## 🙏 Credits

- Inspired by [Centmin Mod](https://centminmod.com)
- [OpenResty](https://openresty.org) - High Performance Web Platform
- [PHP](https://php.net) - The PHP Group  
- [MariaDB](https://mariadb.org) - MariaDB Foundation

## 📈 Roadmap

### Phase 1 ✅
- [x] Remote script loading architecture
- [x] Intelligent caching system
- [x] Core LEMP components
- [x] Multi-PHP support
- [x] Virtual host management
- [x] Commercial module framework

### Phase 2 🚧
- [ ] CDN integration for scripts distribution
- [ ] Script versioning and rollback
- [ ] Advanced monitoring dashboard
- [ ] Load balancer integration
- [ ] Docker containerization

### Phase 3 🔮
- [ ] Multi-server cluster management
- [ ] Auto-scaling capabilities  
- [ ] CI/CD integration
- [ ] Marketplace for extensions
- [ ] Real-time collaboration tools

---

**Made with ❤️ by ThangLQ**

*ThangLQ Stack - Remote Modular LEMP infrastructure cho modern web applications* 🇻🇳 